#include	"ht8.h"
#include 	"eeprom.h"


void WriteEeprom(u8 addr,u8 data)
{
	_eea = addr;
	_eed = data;
	MEMORY_POINT1L = 0x40;
	MEMORY_POINT1H = 0x01;
	_emi = 0;
	IND_ADDR_RESG1 |= 0x08;
	IND_ADDR_RESG1 |= 0x04;
	_emi = 1;
	while((IND_ADDR_RESG1 & 0x04))
	GCC_CLRWDT();	
	MEMORY_POINT1H = 0;
}
 
u8 ReadEeprom(u8 addr)
{
	_eea = addr;
	MEMORY_POINT1L = 0x40;
	MEMORY_POINT1H = 0x01;
	IND_ADDR_RESG1 |= 0x02;
	IND_ADDR_RESG1 |= 0x01;
	while((IND_ADDR_RESG1 & 0x01))
	GCC_CLRWDT();
	IND_ADDR_RESG1 = 0;
	MEMORY_POINT1H = 0;
	return _eed;
}

void MultiWriteEeprom(u8 addr,u8 *databuff,u8 length)
{
	u8	i;
	for(i=0;i<length;i++)
	{
		WriteEeprom(addr,(*databuff));
		addr++;
		databuff++;
	}
}

void MultiReadEpprom(u8 addr,u8 *databuff,u8 length)
{
	u8 i;
	for(i=0;i<length;i++)
	{
		*databuff = ReadEeprom(addr);
		addr++;
		databuff++;
	}
}

